package w83b.w83bOperacionesPaso.w83bIncidencias;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bIncidenciasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bMantenimientos.w83bConvenios.W83bTablaConveniosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaIncidenciasExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoIncidencias.xls";
		InputStream inputStream = W83bTablaConveniosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        
        
        List listaIncidencias = (ArrayList)contexto.get("w83bListaIncidencias");
        W83bIncidenciasBean incidenciasBean = (W83bIncidenciasBean)contexto.get("w83bIncidenciasTempBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets()); 

        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1
        HSSFCell cell = row.createCell((short)3);

        
        row = sheet.getRow((short)5); 
        cell = row.getCell((short)7);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }            
        
        row = sheet.getRow((short)7); 
        cell = row.getCell((short)7);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)0);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloIncidencias_eu",idioma));
        titulo.append(" ");
        titulo.append("/");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloIncidencias_es",idioma));
        cell.setCellValue(titulo.toString());
        
        //MAPEO FORMULARIO
        //NUMERO INCIDENCIA
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.nIncDH"));
        cell = row.createCell((short)2);
        StringBuffer nIncidenciaDesde = new StringBuffer();
        StringBuffer nIncidenciaHasta = new StringBuffer();
        
        boolean desde = false;
        
        if(StringUtils.isNotEmpty(incidenciasBean.getTerritorioIncidenciaDesde())){
        	nIncidenciaDesde.append(incidenciasBean.getTerritorioIncidenciaDesde()).append("/");
        	if(StringUtils.isNotEmpty(incidenciasBean.getAnyoIncidenciaDesde())){
        		nIncidenciaDesde.append(incidenciasBean.getAnyoIncidenciaDesde()).append("/");
        	}else{
        		nIncidenciaDesde.append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(incidenciasBean.getNumIncidenciaDesde())){
        		nIncidenciaDesde.append(incidenciasBean.getNumIncidenciaDesde());
        	}else{
        		nIncidenciaDesde.append("-");
        	}
        	desde = true;
        }
        if(StringUtils.isNotEmpty(incidenciasBean.getTerritorioIncidenciaHasta())){
        	if(desde){
        		nIncidenciaHasta.append(" al ");
        	}
        	nIncidenciaHasta.append(incidenciasBean.getTerritorioIncidenciaHasta()).append("/");
        	if(StringUtils.isNotEmpty(incidenciasBean.getAnyoIncidenciaHasta())){
        		nIncidenciaHasta.append(incidenciasBean.getAnyoIncidenciaHasta()).append("/");
        	}else{
        		nIncidenciaHasta.append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(incidenciasBean.getNumIncidenciaHasta())){
        		nIncidenciaHasta.append(incidenciasBean.getNumIncidenciaHasta());
        	}else{
        		nIncidenciaHasta.append("-");
        	}
        }
        if(!StringUtils.isEmpty(nIncidenciaDesde.toString())||!StringUtils.isEmpty(nIncidenciaHasta.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(nIncidenciaDesde.toString() +nIncidenciaHasta.toString() );
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue(nIncidenciaDesde.toString() +nIncidenciaHasta.toString() );
        }
        
      //fin NUMERO INCIDENCIA
        
        //NUMERO ACTA
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nActaDH"));
        cell = row.createCell((short)8);        
        StringBuffer nActaDesde = new StringBuffer();
        StringBuffer nActaHasta = new StringBuffer();
        
        desde = false;
        
        if(StringUtils.isNotEmpty(incidenciasBean.getTerritorioActaDesde())){
        	nActaDesde.append(incidenciasBean.getTerritorioActaDesde()).append("/");
        	if(StringUtils.isNotEmpty(incidenciasBean.getAnyoActaDesde())){
        		nActaDesde.append(incidenciasBean.getAnyoActaDesde()).append("/");
        	}else{
        		nActaDesde.append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(incidenciasBean.getNumActaDesde())){
        		nActaDesde.append(incidenciasBean.getNumActaDesde());
        	}else{
        		nActaDesde.append("-");
        	}
        	desde = true;
        }
        if(StringUtils.isNotEmpty(incidenciasBean.getTerritorioActaHasta())){
        	if(desde){
        		nActaHasta.append(" al ");
        	}
        	nActaHasta.append(incidenciasBean.getTerritorioActaHasta()).append("/");
        	if(StringUtils.isNotEmpty(incidenciasBean.getAnyoActaHasta())){
        		nActaHasta.append(incidenciasBean.getAnyoActaHasta()).append("/");
        	}else{
        		nActaHasta.append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(incidenciasBean.getNumActaHasta())){
        		nActaHasta.append(incidenciasBean.getNumActaHasta());
        	}else{
        		nActaHasta.append("-");
        	}
        }
        
        
        if(!StringUtils.isEmpty(nActaDesde.toString())||!StringUtils.isEmpty(nActaHasta.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("8"),W83bClsConstantes.DOCE,Short.parseShort("11")));//NOPMD
        	cell.setCellValue(nActaDesde.toString() +nActaHasta.toString() );
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue(nActaDesde.toString() +nActaHasta.toString() );
        }

        //FIN ACTA
       
        //FECHA ENTRADA
        row = sheet.getRow((short)14); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.fEntraDH"));
        cell = row.createCell((short)2);        
        StringBuffer fechaEntradaDesde = new StringBuffer();
        StringBuffer  fechaEntradaHasta = new StringBuffer();
        
        desde = false;
        
        if(StringUtils.isNotEmpty(incidenciasBean.getFechaEntradaDesde())){
        	fechaEntradaDesde.append(incidenciasBean.getFechaEntradaDesde());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(incidenciasBean.getFechaEntradaHasta())){
        	if(desde){
        		fechaEntradaHasta.append("-");
        	}
        	fechaEntradaHasta.append(incidenciasBean.getFechaEntradaHasta());
        }
        if(StringUtils.isNotEmpty(fechaEntradaDesde.toString())||StringUtils.isNotEmpty(fechaEntradaHasta.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("2"),W83bClsConstantes.CATORCE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(fechaEntradaDesde.toString() +fechaEntradaHasta.toString() );
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue(fechaEntradaDesde.toString() +fechaEntradaHasta.toString() );
        }
        //FIN FECHA ENTRADA
              
        
        //SOLICITANTE        
        row = sheet.getRow((short)14); 
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.tipoSolicitanteTxt"));
        cell = row.createCell((short)8);
        if(StringUtils.isNotEmpty(incidenciasBean.getTipoSolicitante())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("8"),W83bClsConstantes.CATORCE,Short.parseShort("10")));//NOPMD
        	cell.setCellValue(incidenciasBean.getTipoSolicitanteTxt().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue(incidenciasBean.getTipoSolicitanteTxt());
        }
        cell = row.getCell((short)11); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.dniSolicitanteTxt"));
        cell = row.createCell((short)14);        
        if(StringUtils.isNotEmpty(incidenciasBean.getDniSolicitante())){
        	cell.setCellValue(incidenciasBean.getDniSolicitante().toUpperCase());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.nombreSolicitanteAbr"));
        cell = row.createCell((short)8);   
        if(StringUtils.isNotEmpty(incidenciasBean.getNombreSolicitante())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE,Short.parseShort("8"),W83bClsConstantes.QUINCE,Short.parseShort("11")));//NOPMD
	        cell.setCellValue(incidenciasBean.getNombreSolicitante().toUpperCase()); 
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.QUINCE,excel,wb));
        }else{
        	cell.setCellValue(incidenciasBean.getNombreSolicitante());
        }
        row = sheet.getRow((short)17); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.tipologia"));
        cell = row.createCell((short)2);
        if(StringUtils.isNotEmpty(incidenciasBean.getTipologiaIncidenciaTxt())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE,Short.parseShort("2"),W83bClsConstantes.DIECISIETE,Short.parseShort("5")));//NOPMD
        	cell.setCellValue(incidenciasBean.getTipologiaIncidenciaTxt().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECISIETE,excel,wb));
        }else{
        	cell.setCellValue(incidenciasBean.getTipologiaIncidenciaTxt());
        }
        row = sheet.getRow((short)19); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.tramite"));
        cell = row.createCell((short)2);
        if(StringUtils.isNotEmpty(incidenciasBean.getTramite())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE,Short.parseShort("2"),W83bClsConstantes.DIEZYNUEVE,Short.parseShort("5")));//NOPMD
        	cell.setCellValue(incidenciasBean.getTramiteTxt().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIEZYNUEVE,excel,wb));
        }else{
        	cell.setCellValue(incidenciasBean.getTramiteTxt());
        }
        //VALIDADA / DESCARTADA / NO VALIDADA
//        row = sheet.getRow((short)12); 
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.rev"));
        cell = row.getCell((short)8); 
        StringBuffer estadoRev = new StringBuffer();      
        if(StringUtils.isNotEmpty(incidenciasBean.getFlagBusqValidada())){
        	estadoRev.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.noValidada",idioma));
        }
        if(StringUtils.isNotEmpty(incidenciasBean.getFlagBusqNoValidada())){
        	if(estadoRev.length()>0){
        		estadoRev.append(" - ");
        	}
        	estadoRev.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.validada",idioma));
        }
        if(StringUtils.isNotEmpty(incidenciasBean.getFlagBusqDescartada())){
        	if(estadoRev.length()>0){
        		estadoRev.append(" - ");
        	}
        	estadoRev.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.descartada",idioma));
        }
        sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE,Short.parseShort("8"),W83bClsConstantes.DIEZYNUEVE,Short.parseShort("10")));//NOPMD
        cell.setCellValue(estadoRev.toString());
        
        //FIN VALIDADA / DESCARTADA / NO VALIDADA
        row = sheet.getRow((short)20); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.incidencias.fTramDH"));
        cell = row.createCell((short)2);              
        StringBuffer fechaTramiteDesde = new StringBuffer();
        StringBuffer fechaTramiteHasta = new StringBuffer();
        
        desde = false;
        
        if(StringUtils.isNotEmpty(incidenciasBean.getFechaTramiteDesde())){
        	fechaTramiteDesde.append(incidenciasBean.getFechaTramiteDesde());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(incidenciasBean.getFechaTramiteHasta())){
        	if(desde){
        		fechaTramiteHasta.append("-");
        	}
        	fechaTramiteHasta.append(incidenciasBean.getFechaTramiteHasta());
        }
        if(StringUtils.isNotEmpty(fechaTramiteDesde.toString())||StringUtils.isNotEmpty(fechaTramiteHasta.toString())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE,Short.parseShort("2"),W83bClsConstantes.VEINTE,Short.parseShort("3")));//NOPMD
	        cell.setCellValue(fechaTramiteDesde.toString() +fechaTramiteHasta.toString() );
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.VEINTE,excel,wb));
        }else{
        	cell.setCellValue(fechaTramiteDesde.toString() +fechaTramiteHasta.toString() );
        }
        row = sheet.getRow((short)21); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.ultTramite"));
        cell = row.createCell((short)2);        
        
        String ultTramite = "";
        
        if(W83bClsConstantes.CONSTANTE_SI.equals(incidenciasBean.getUltimoTramite())){
        	ultTramite = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }else{
        	ultTramite = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);        	
        }        
        cell.setCellValue(ultTramite.toUpperCase()); 
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.VEINTIUNA,excel,wb));
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow((short)24); // Creacin de la fila 1
        cell = row.getCell((short)0); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(new StringBuffer(W83bClsConstantes.UNO).append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.nIncidenciaCorto",W83bClsConstantes.CONSTANTE_EUSKARA))
        		.append(" / ")
        		.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.nIncidenciaCorto",W83bClsConstantes.CONSTANTE_CASTELLANO)).toString());
        cell = row.getCell((short)1); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(new StringBuffer(W83bClsConstantes.UNO).append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.fecha",W83bClsConstantes.CONSTANTE_EUSKARA))
        		.append(" / ")
        		.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.fecha",W83bClsConstantes.CONSTANTE_CASTELLANO)).toString());

        cell = row.getCell((short)2); 
        cell.setCellValue(new StringBuffer(W83bClsConstantes.UNO).append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.nActa",W83bClsConstantes.CONSTANTE_EUSKARA))
        		.append(" / ")
        		.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.nActa",W83bClsConstantes.CONSTANTE_CASTELLANO)).toString());
        
        cell = row.getCell((short)3); 
        cell.setCellValue(new StringBuffer(W83bClsConstantes.UNO).append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.tipSolicitante",W83bClsConstantes.CONSTANTE_EUSKARA))
        		.append(" / ")
        		.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.tipSolicitante",W83bClsConstantes.CONSTANTE_CASTELLANO)).toString());
        
        cell = row.getCell((short)8); 
        cell.setCellValue(new StringBuffer(W83bClsConstantes.UNO).append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.solicitante",W83bClsConstantes.CONSTANTE_EUSKARA))
        		.append(" / ")
        		.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.solicitante",W83bClsConstantes.CONSTANTE_CASTELLANO)).toString());
        
        cell = row.getCell((short)13); 
        cell.setCellValue(new StringBuffer(W83bClsConstantes.UNO).append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.tipologia",W83bClsConstantes.CONSTANTE_EUSKARA))
        		.append(" / ")
        		.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.tipologia",W83bClsConstantes.CONSTANTE_CASTELLANO)).toString());
        cell = row.getCell((short)14); 
        cell.setCellValue(new StringBuffer(W83bClsConstantes.UNO).append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.estadoRevision",W83bClsConstantes.CONSTANTE_EUSKARA))
        		.append(" / ")
        		.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.estadoRevision",W83bClsConstantes.CONSTANTE_CASTELLANO)).toString());
        cell = row.getCell((short)15); 
        cell.setCellValue(new StringBuffer(W83bClsConstantes.UNO).append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_EUSKARA))
        		.append(" / ")
        		.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_CASTELLANO)).toString());
        
        if(null!=listaIncidencias){
	        for(int i=0;i<listaIncidencias.size();i++){
	        	row = sheet.createRow((short)25+i); // Creacin de la fila 1
	        	
//	        	//N INCIDENCIA
	        	cell = row.createCell((short)0); 
	        	StringBuffer nIncidencia = new StringBuffer(W83bClsConstantes.UNO);//NOPMD
	        	nIncidencia.append(((W83bIncidenciasBean)listaIncidencias.get(i)).getTerritorioIncidencia())
	        			   .append("/")
	        			   .append(((W83bIncidenciasBean)listaIncidencias.get(i)).getAnyoIncidencia())
	        			   .append("/")
	        			   .append(((W83bIncidenciasBean)listaIncidencias.get(i)).getNumIncidenciaSencillo());
	        	cell.setCellValue(nIncidencia.toString());
	        	cell.setCellStyle(estiloFila(i,excel));
	        	
//	        	//Fecha entrada
	        	cell = row.createCell((short)1); 
	        	 if(StringUtils.isNotEmpty(((W83bIncidenciasBean)listaIncidencias.get(i)).getFechaEntrada())){
	        		 cell.setCellValue(((W83bIncidenciasBean)listaIncidencias.get(i)).getFechaEntrada());
	        	 }
	        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
	        	
	        	//Numero Acta
	        	cell = row.createCell((short)2); 
	        	if(StringUtils.isNotEmpty(((W83bIncidenciasBean)listaIncidencias.get(i)).getNumActa())){
	        		cell.setCellValue(((W83bIncidenciasBean)listaIncidencias.get(i)).getNumActa());
	        	}
	        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
	        	
	        	//Tipo Solicitante
	        	cell = row.createCell((short)3); 
	        	HSSFCell cell2 = row.createCell((short)4); 
	        	HSSFCell cell3 = row.createCell((short)5); 
	        	HSSFCell cell4 = row.createCell((short)6); 
	        	HSSFCell cell5 = row.createCell((short)7); 
	        	String tipoSolicitante = "";//NOMPD
	        	if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
	        		tipoSolicitante = ((W83bIncidenciasBean)listaIncidencias.get(i)).getTipSolicitanteCast();
	        	}else{
	        		tipoSolicitante = ((W83bIncidenciasBean)listaIncidencias.get(i)).getTipSolicitanteEusk();
	        	}
	        	if(StringUtils.isNotEmpty(tipoSolicitante)){
	        		tipoSolicitante = tipoSolicitante.toUpperCase();
	        	}
	        	cell.setCellValue(tipoSolicitante);	        		
	        	sheet.addMergedRegion(new Region(25+i,(short)3,25+i,(short)7)); //NOPMD
	        	cell.setCellStyle(estiloFila(i,excel));
	        	cell2.setCellStyle(estiloFilaNoJustif(i,excel));
	        	cell3.setCellStyle(estiloFilaNoJustif(i,excel));
	        	cell4.setCellStyle(estiloFilaNoJustif(i,excel));
	        	cell5.setCellStyle(estiloFilaNoJustif(i,excel));
	        	//Solicitante
	        	cell = row.createCell((short)8); 
	        	cell2 = row.createCell((short)9); 
	        	cell3 = row.createCell((short)10); 
	        	cell4 = row.createCell((short)11); 
	        	cell5 = row.createCell((short)12);

	        	sheet.addMergedRegion(new Region(25+i,(short)8,25+i,(short)12)); //NOPMD
	        	if(StringUtils.isNotEmpty(((W83bIncidenciasBean)listaIncidencias.get(i)).getSolicitante())){
	        		cell.setCellValue(((W83bIncidenciasBean)listaIncidencias.get(i)).getSolicitante().toUpperCase());
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFilaNoJustif(i,excel));
	        	cell2.setCellStyle(estiloFilaNoJustif(i,excel));
	        	cell3.setCellStyle(estiloFilaNoJustif(i,excel));
	        	cell4.setCellStyle(estiloFilaNoJustif(i,excel));
	        	cell5.setCellStyle(estiloFilaNoJustif(i,excel));
	        	
	        	//tipologa
	        	cell = row.createCell((short)13); 
	        	if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
	        		if(StringUtils.isNotEmpty(((W83bIncidenciasBean)listaIncidencias.get(i)).getTipologiaCast())){
	        			cell.setCellValue(((W83bIncidenciasBean)listaIncidencias.get(i)).getTipologiaCast().toUpperCase());
	        		}else{
	        			cell.setCellValue(((W83bIncidenciasBean)listaIncidencias.get(i)).getTipologiaCast());
	        		}
	        	}else{
	        		if(StringUtils.isNotEmpty(((W83bIncidenciasBean)listaIncidencias.get(i)).getTipologiaEusk())){
	        			cell.setCellValue(((W83bIncidenciasBean)listaIncidencias.get(i)).getTipologiaEusk().toUpperCase());
	        		}else{
	        			cell.setCellValue(((W83bIncidenciasBean)listaIncidencias.get(i)).getTipologiaEusk());
	        		}
	        	}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	
	        	
	        	if(StringUtils.isNotEmpty(tipoSolicitante)&&34<(tipoSolicitante.length())){
	        		row.setHeightInPoints((short)(22*(tipoSolicitante.length()/34)+1));
	        	}
	        	
	        	
	        	cell = row.createCell((short)14); 
	        	if(W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(((W83bIncidenciasBean)listaIncidencias.get(i)).getFlagValidada())){
	        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.noValidada",idioma).toUpperCase());
	    		}else if(W83bClsConstantes.CONSTANTE_VALIDADA.equals(((W83bIncidenciasBean)listaIncidencias.get(i)).getFlagValidada())){
	    			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.validada",idioma).toUpperCase());			
	    		}else{
	    			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.incidencias.descartada",idioma).toUpperCase());
	    		}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	
	        	
	        	cell = row.createCell((short)15); 
	        	cell.setCellValue(((W83bIncidenciasBean)listaIncidencias.get(i)).getRazon().toUpperCase());
	        	cell.setCellStyle(estiloFila(i,excel));
	        	
	        	
	        	if(StringUtils.isNotEmpty(((W83bIncidenciasBean)listaIncidencias.get(i)).getRazon())&&34<(((W83bIncidenciasBean)listaIncidencias.get(i)).getRazon().length())){
	        		row.setHeightInPoints((short)(22*(((W83bIncidenciasBean)listaIncidencias.get(i)).getRazon().length()/34)+1));
	        	}
	        }
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoIncidencias.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}		
	}
	
	
	/**
	 * Estilo fila no justif.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNoJustif(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNoJustif;
		}else{
			return excel.styleTextoImparNoJustif;			
		}		
	}
	

	
	/**
 * Estilo fila numero centrado.
 *
 * @param nFila the n fila
 * @param excel the excel
 * @return the hSSF cell style
 */
private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
		styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
		HSSFFont fuente = wb.createFont();
		fuente.setFontHeightInPoints((short) 9);
		styleNumeroPar.setFont(fuente);			 
		styleNumeroPar.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
		return styleNumeroPar;
	}

}
